# AI Content Rewriter Chrome Extension

A powerful Chrome extension that enhances web forms with AI-powered content rewriting capabilities. Now with **custom rewrite rules** and **Spark Interact branding**!

## ✨ New Features

### 🎯 Custom Rewrite Rules
- **General Rules**: Apply to all rewrites (e.g., maintain original meaning, avoid jargon)
- **Tone-Specific Rules**: Customize behavior for each tone (professional, casual, creative, formal, friendly)
- **Length-Specific Rules**: Define how content should be shortened or expanded
- **Content Type Rules**: Specify rules for different content types (emails, blog posts, reports)

### 🔧 Enhanced Settings
- **Tabbed Interface**: Separate tabs for main settings and custom rules
- **Real-time Preview**: See your current rules configuration at a glance
- **Persistent Storage**: Rules are saved locally and persist across sessions

### 🚀 Improved AI Integration
- **Rule-Based Prompts**: AI APIs now receive your custom rules instead of generic instructions
- **Better Quality**: More consistent, targeted rewrites based on your specifications
- **Multiple Providers**: Support for OpenAI GPT, Google Gemini, and Anthropic Claude

### 🎨 Professional Branding
- **Spark Interact Footer**: Proper attribution to the development team
- **Modern UI**: Clean, professional interface with improved usability

## 🚀 Installation

1. Download or clone this repository
2. Open Chrome and go to `chrome://extensions/`
3. Enable "Developer mode" in the top right
4. Click "Load unpacked" and select the extension folder
5. The extension icon should appear in your toolbar

## ⚙️ Configuration

### 1. API Key Setup
1. Click the extension icon
2. Go to the **Main** tab
3. Select your preferred AI provider
4. Enter your API key
5. Click "Save Settings"

### 2. Custom Rules Configuration
1. Click the **Rules** tab
2. Configure rules for different scenarios:
   - **General Rules**: Apply to all rewrites
   - **Tone Rules**: Specific instructions for each tone
   - **Length Rules**: How to handle content length changes
   - **Content Type Rules**: Format and style guidelines
3. Click "Save Rules"

## 📝 Usage

### Basic Rewriting
1. Navigate to any webpage with text inputs or textareas
2. Look for the **✦** button next to input fields
3. Enter your text
4. Click the button to open the rewrite modal
5. Select tone and length preferences
6. Choose from 3 AI-generated alternatives
7. Apply your preferred rewrite

### Keyboard Shortcuts
- **Ctrl+Shift+R**: Trigger rewrite for the currently focused input field

### Supported Input Types
- Text inputs (`<input type="text">`)
- Email inputs (`<input type="email">`)
- Textareas (`<textarea>`)
- Contenteditable elements (`[contenteditable="true"]`)

## 🎯 Rule Examples

### Professional Tone Rules
```
Use formal business language, industry terminology, clear structure, and professional tone. Avoid contractions and casual expressions.
```

### Shorter Length Rules
```
Make content concise by removing redundancy, focusing on key points, using active voice, and eliminating unnecessary words.
```

### Content Type Rules
```
Emails should be concise and action-oriented. Blog posts should be engaging with storytelling elements. Reports should be structured with clear headings.
```

## 🔌 Supported AI Providers

### OpenAI GPT
- **Model**: GPT-3.5-turbo
- **API Endpoint**: `https://api.openai.com/v1/chat/completions`
- **Key Format**: `sk-...`

### Google Gemini
- **Model**: Gemini 2.0 Flash Lite
- **API Endpoint**: `https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash-lite:generateContent`
- **Key Format**: `AIza...`

### Anthropic Claude
- **Model**: Claude 3 Haiku
- **API Endpoint**: `https://api.anthropic.com/v1/messages`
- **Key Format**: `sk-ant-...`

## 🧪 Testing

Use the included `demo.html` file to test the extension:
1. Open `demo.html` in Chrome
2. Install the extension
3. Configure your API key and rules
4. Test rewriting on various input fields

## 🔒 Privacy & Security

- **Local Storage**: All settings and rules are stored locally in your browser
- **API Key Encryption**: API keys are encrypted before storage
- **No Data Collection**: The extension doesn't collect or transmit your content
- **Rate Limiting**: Built-in rate limiting to prevent API abuse

## 🛠️ Technical Details

### Architecture
- **Background Script**: Handles API calls and data management
- **Content Script**: Injects rewrite buttons and manages UI
- **Popup**: Settings and rules configuration interface
- **Storage**: Chrome extension storage for persistence

### File Structure
```
├── manifest.json           # Extension configuration
├── background_script.js    # Background service worker
├── content_script.js       # Content injection and UI
├── popup_html.html         # Settings popup interface
├── popup_script.js         # Popup functionality
├── content_styles.css      # Content script styles
├── demo.html              # Testing interface
└── icons/                 # Extension icons
```

## 🚀 Future Enhancements

- [ ] Template-based rules for common use cases
- [ ] Rule import/export functionality
- [ ] Advanced prompt engineering options
- [ ] Batch rewriting capabilities
- [ ] Integration with popular writing tools

## 🤝 Contributing

This extension was developed by [Spark Interact](https://www.sparkinteract.com.au/), a professional web design and development agency based in Sydney, Australia.

## 📄 License

This project is proprietary software developed by Spark Interact. All rights reserved.

## 🆘 Support

For support or feature requests, please contact Spark Interact:
- **Website**: [https://www.sparkinteract.com.au/](https://www.sparkinteract.com.au/)
- **Phone**: 1300 799 858
- **Email**: Contact through website

---

**Developed with ❤️ by [Spark Interact](https://www.sparkinteract.com.au/)**
